% function satNetwork
% by Darren Chang (darrenz@mit.edu)
% last modified on 9/7/02

function [GWKLOC,NGW,personnel] = satellitenetwork(constel,ISL,Nmin,NPmin,Afoot)

GWKLOC	= 6.3;         % ground system thousand lines of code, estimated based on GlobalStar, ARIES, ORBCOMM, and Starnet

Afoot_GS = 2.6398e7;    % footprint area of Globalstar in km^2

if ISL == 0        % no ISL
    NGW	= round(50*Afoot_GS/Afoot);	 % number of GW is inversely proportional to the footprint area
elseif ISL == 1    % with ISL
    NGW = NPmin*2;   % 2 gound stations per plane   
else
    disp(' ');
    disp('ISL option error!');
end;
personnel= (NGW*3 + 2*10)*(24/8);	% number of personnel required 24 hours a day 
					                % at all ground stations and 2 command centers

